proc tabulate data = ghpb12;
class ent2 INS3 filingsize / PRELOADFMT;
title 'Table B4. Premiums Paid by Group Health Plans';
title2 'by type of insurance, type of plan, and type of insurance contracts, 2012';
title3 '(numbers in millions)';
var TOT_PREM HEALTH_ONLY_PREM STOPLOSS_ONLY_PREM OTHER_ONLY_PREM HEALTH_STOPLOSS_PREM HEALTH_OTHER_PREM STOPLOSS_OTHER_PREM HEALTH_STOPLOSS_OTHER_PREM;
table all='All Plans' filingsize=' ', 
(TOT_PREM ='Total'
HEALTH_ONLY_PREM ='Health only'
STOPLOSS_ONLY_PREM ='Stop-Loss only'
OTHER_ONLY_PREM ='Other'
HEALTH_STOPLOSS_PREM ='Health and Stop-Loss'
HEALTH_OTHER_PREM ='Health and Other'
STOPLOSS_OTHER_PREM ='Stop-Loss and Other'
HEALTH_STOPLOSS_OTHER_PREM='Health, Stop-Loss, and Other')*sum=' '*f=m12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;
